


$(function () {

    "use strict";

    var wind = $(window);
    
    // ----------------- accordion --------------

    var accordion = $('.accordion'),
    accordionHead = $('.accordion .card-head');

    accordionHead.on('click', function () {

        $(this).next(".card-body").slideToggle();
    });

    accordion.on('click', function (e) {
        e.stopPropagation();
        $(this).addClass("active").siblings().removeClass("active");
        $(this).siblings().find('.card-body').slideUp()
    });

    $('html').on('click', function () {
        accordion.removeClass("active");
        accordion.find('.card-body').slideUp()
    });

    /* ----------------------------------------------------------------
                [ niceScroll ]
    -----------------------------------------------------------------*/

    $(function () {
        $(".blocks .clients .chat-bo").niceScroll({
            cursorcolor: "#999",
            cursorwidth: "4px",
            cursorborder: 0,
            background: "rgba(20,20,20,0.1)",
        });
    });


    /* ----------------------------------------------------------------
                [ Navbar ( Change Background & Logo ) ]
    -----------------------------------------------------------------*/

    wind.on("scroll", function () {

        var bodyScroll = wind.scrollTop(),
            navbar = $(".nav-top.change"),
            xmenu = $(".xmenu");

        if (bodyScroll > 100) {

            navbar.addClass("nav-scroll");
            xmenu.addClass("scrolling");

        } else {

            navbar.removeClass("nav-scroll");
            xmenu.removeClass("scrolling");
        }
    });


    /* ----------------------------------------------------------------
                    [ sidrbar & xmenu ]
    -----------------------------------------------------------------*/

    $('.nav-top').on('click', '.toggle-icon', function () {

        $(".side-bar").toggleClass("small");
        $("main").toggleClass("full-width");

    });

    $('.xmenu').on('click', '#cn-button', function () {

        $(".reportup").toggleClass("down");

    });


    /* ----------------------------------------------------------------
                    [ datepicker ]
    -----------------------------------------------------------------*/


    var datepickerday = $(".datepicker1 ul li[data-view='day picked']").text();
    var datepickermonth = $(".datepicker1 ul li[data-view='month current']").text();

    $(".datepickerday1").text(datepickerday);

    $(".datepickermonth1").text(datepickermonth);


    $(".datepicker1 ul").on('click', 'li[data-view="day"]', function () {

        var datepickerday = $(this).text();
        var datepickermonth = $(".datepicker1 ul li[data-view='month current']").text();

        $(".datepickerday1").text(datepickerday);

        $(".datepickermonth1").text(datepickermonth);

    });

    $(".datepicker2 ul").on('click', 'li[data-view="day"]', function () {

        var datepickerday = $(this).text();
        var datepickermonth = $(".datepicker2 ul li[data-view='month current']").text();

        $(".datepickerday2").text(datepickerday);

        $(".datepickermonth2").text(datepickermonth);

    });

    /* ----------------------------------------------------------------
                    [ ul.tabs ]
    -----------------------------------------------------------------*/

    $('ul.tabs .tab-link').click(function () {
        var tab_id = $(this).attr('data-tab');

        $('ul.tabs .tab-link').removeClass('current');
        $('.tab-content').removeClass('current');

        $(this).addClass('current');
        $("#" + tab_id).addClass('current');
    });




    /* ----------------------------------------------------------------
                [ Sections Background Image With Data ]
-----------------------------------------------------------------*/

    var pageSection = $(".bg-img, section");
    pageSection.each(function (indx) {

        if ($(this).attr("data-background")) {
            $(this).css("background-image", "url(" + $(this).data("background") + ")");
        }
    });

    /* ----------------------------------------------------------------
                    [ Carousel ]
    -----------------------------------------------------------------*/

    $('.slider').slick({
        autoplay: true,
        draggable: true,
        fade: true,
        speed: 8000,
        infinite: true,
        cssEase: 'cubic-bezier(0.7, 0, 0.3, 1)',
        touchThreshold: 100,
        dots: false,
        arrows: false,
        rtl: true
    });


    $('.slider-for').slick({
        slidesToShow: 1,
        slidesToScroll: 1,
        infinite: false,
        arrows: true,
        asNavFor: '.slider-nav',
        rtl: true
    });

    $('.slider-nav').slick({
        slidesToShow: 4,
        slidesToScroll: 1,
        infinite: false,
        asNavFor: '.slider-for',
        dots: false,
        arrows: true,
        focusOnSelect: true,
        rtl: true
    });


    $('.testim .clients-slider').slick({
        slidesToShow: 2,
        autoplay: false,
        draggable: true,
        infinite: true,
        dots: true,
        rtl: true,
        responsive: [
            {
                breakpoint: 768,
                settings: {
                    slidesToShow: 1
                }
            }
        ]
    });

    // products owlCarousel
    $('.carousel-three .owl-carousel').owlCarousel({
        rtl: true,
        loop: true,
        items: 3,
        margin: 0,
        dots: false,
        nav: true,
        navText: ["<span class='ti-angle-right'></span>", "<span class='ti-angle-left'></span>"],
        autoplay: true,
        smartSpeed: 400,
        responsiveClass: true,
        responsive: {
            0: {
                items: 1
            },
            600: {
                items: 2
            },
            1000: {
                items: 3
            }
        }
    });

});



// === window When Loading === //

$(window).on("load", function () {

    var wind = $(window);

    /* ----------------------------------------------------------------
                    [ Preloader ]
    -----------------------------------------------------------------*/

    $(".loading").delay(1500).fadeOut(500);

    /* ----------------------------------------------------------------
                [ magnificPopup ]
    -----------------------------------------------------------------*/

    $('.reports-table').magnificPopup({
        delegate: '.popimg',
        type: 'image',
        gallery: {
            enabled: true
        }
    });

});


$(document).ready(function () {
    $('.nav-top .nav-full-icon, .nav-full-screen #nav-icon').click(function () {
        $(".nav-full-screen").toggleClass('open');
    });
});

