<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Groups extends Model
{
    protected $table = "groups";
    protected $fillable = [
    	'user_id',
    	'adv_id',
    	'type',
    	'image',
    ];

    public function transaltions()
    {
    	return $this->hasMany('App\GroupsTranslation','group_id','id');
    }

    public function members()
    {
        return $this->hasMany('App\GroupMembers','group_id','id');
    }


    public function adminstrator()
    {
        return $this->belongsTo('App\User','user_id');
    }
}
