<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\City,App\CityTranslation;
use Jenssegers\Agent\Agent;
use App\Http\Requests\Admin\CountriesRequest;
use App\Helpers\DoFire;
use Session;
use Auth;

class CitiesController extends Controller
{
	public $view = 'panel.cities.';
    public function __construct(City $city,CityTranslation $translation)
	{
        $this->city = $city;
        $this->translation = $translation;
	}

	public function index($place_id,Request $request)
    {
    	$cities = $this->city->where('place_id',$place_id)->with('translation')->get();
    	$agent = new Agent();
        $agent = $agent->platform().','.$agent->browser().$agent->version($agent->browser());
        $data = ['key'=>'dashboard_list_countries','text'=>'List All Countries','browser'=>$agent];
        DoFire::MK_REPORT($data,Auth::id(),null,$request->ipinfo);
    	return view($this->view.'index',compact('cities'));
    }

   	public function create(Request $request,$place_id)
    {
    	$place_id = $place_id;
    	$agent = new Agent();
        $agent = $agent->platform().','.$agent->browser().$agent->version($agent->browser());
        $data = ['key'=>'dashboard_create_new_cities_view','text'=>'Create_New_city View','browser'=>$agent];
        DoFire::MK_REPORT($data,Auth::id(),null,$request->ipinfo);
    	return view($this->view.'create',compact('place_id'));
    }


    public function store(CountriesRequest $request,$place_id)
    {
    	$create = $this->city->create([
    		'place_id'=>$place_id
    	]);
        // dd($place_id);
    	foreach ($request->lang as $key => $lang) {
	    	$translation = $this->translation->create([
	    		'name'=>$request->name[$key],
	    		'lang_id'=>$lang,
	    		'city_id'=>$create->id
	    	]);
    	}

    	$agent = new Agent();
    	$agent = $agent->platform().','.$agent->browser().$agent->version($agent->browser());
        $data = ['key'=>'dashboard_create_new_city','text'=>'Create New city','browser'=>$agent];
        session::flash('success',trans('home.message_success'));
    	return redirect()->back();
    }

 	public function destroy($id,Request $request)
    {
    	$this->city->destroy($id);
    	$agent = new Agent();
    	$agent = $agent->platform().','.$agent->browser().$agent->version($agent->browser());
        $data = ['key'=>'dashboard_delete_city','text'=>'Delete city','browser'=>$agent];
        session::flash('success',trans('home.message_success'));
    	return redirect()->back();
    }
    public function destroySelected(Request $request)
    {
    	$this->city->whereIn('id',$request->ids)->delete();
    	$agent = new Agent();
    	$agent = $agent->platform().','.$agent->browser().$agent->version($agent->browser());
        $data = ['key'=>'dashboard_delete_cities','text'=>'Delete cities','browser'=>$agent];
        session::flash('success',trans('home.message_success'));
    	return redirect()->back();
    }
}
