<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Events,App\EventsTranslation;
use Jenssegers\Agent\Agent;
use App\Http\Requests\Admin\EventRequest;
use App\Helpers\DoFire;
use App\Place;
use Session;
use Auth;

class Eventsontroller extends Controller
{
	public $view = 'panel.events.';
    
    public function __construct(Events $event,EventsTranslation $translation)
	{
        $this->event = $event;
        $this->translation = $translation;
	}

	public function index(Request $request)
	{
		$events=$this->event->with('translations')->get();
		$agent = new Agent();
        $agent = $agent->platform().','.$agent->browser().$agent->version($agent->browser());
        $data = ['key'=>'dashboard_list_events','text'=>'List All events','browser'=>$agent];
        DoFire::MK_REPORT($data,Auth::id(),null,$request->ipinfo);
    	return view($this->view.'index',compact('events'));
	}


	public function create(Request $request)
	{
		$event=[];
		$places = Place::all(); 
		$agent = new Agent();
        $agent = $agent->platform().','.$agent->browser().$agent->version($agent->browser());
        $data = ['key'=>'dashboard_create_events','text'=>'List Create Events','browser'=>$agent];
        DoFire::MK_REPORT($data,Auth::id(),null,$request->ipinfo);
    	return view($this->view.'create',compact('event','places'));
	}

	public function store(EventRequest $request)
	{
		$create = $this->event->create([
			'place_id'=>$request->place,
			'user_id'=>Auth::id(),
			'price'=>$request->price
		]);
		
		foreach ($request->lang as $key => $lang) {
	    	$translation = $this->translation->create([
	    		'name'=>$request->name[$key],
	    		'description'=>$request->description[$key],
	    		'lang_id'=>$lang,
	    		'event_id'=>$create->id
	    	]);
    	}

    	$agent = new Agent();
    	$agent = $agent->platform().','.$agent->browser().$agent->version($agent->browser());
        $data = ['key'=>'dashboard_create_new_event','text'=>'Create New event','browser'=>$agent];
        DoFire::MK_REPORT($data,Auth::id(),$this->event->find($create->id),$request->ipinfo);
       
        session::flash('success',trans('home.message_success'));

        return redirect()->back();
	}

	public function edit(Request $request,$id)
	{
		$event=$this->event->find($id);
		$places = Place::all(); 
		$agent = new Agent();
        $agent = $agent->platform().','.$agent->browser().$agent->version($agent->browser());
        $data = ['key'=>'dashboard_create_events','text'=>'List Create Events','browser'=>$agent];
        DoFire::MK_REPORT($data,Auth::id(),null,$request->ipinfo);
    	return view($this->view.'edit',compact('event','places'));
	}

	public function update(EventRequest $request,$id)
	{
		 $this->event->find($id)->update([
			'place_id'=>$request->place,
			'user_id'=>Auth::id(),
			'price'=>$request->price
		]);
		
		$this->translation->where('event_id',$id)->delete();		
		foreach ($request->lang as $key => $lang) {
	    	$translation = $this->translation->create([
	    		'name'=>$request->name[$key],
	    		'description'=>$request->description[$key],
	    		'lang_id'=>$lang,
	    		'event_id'=>$id
	    	]);
    	}

    	$agent = new Agent();
    	$agent = $agent->platform().','.$agent->browser().$agent->version($agent->browser());
        $data = ['key'=>'dashboard_update_event_id','text'=>'update event info','browser'=>$agent];
        DoFire::MK_REPORT($data,Auth::id(),$this->event->find($id),$request->ipinfo);

        session::flash('success',trans('home.message_success'));
        return redirect()->back();
	}

	    public function destroy(Request $request,$id)
    {

       $agent = new Agent();
       $agent = $agent->platform().','.$agent->browser().$agent->version($agent->browser());
       $data = ['key'=>'dashboard_destroy_opportunities_info','text'=>'Destroy opportunities Info','browser'=>$agent];
       $info  = $this->event->find($id);

       DoFire::MK_REPORT($data,Auth::id(),$info,$request->ipinfo);
       $this->event->destroy($id);
      Session::flash('success',trans('home.message_success'));
      return redirect()->back();
    }


    public function destroySelected (Request $request)
    {

       $agent = new Agent();
       $agent = $agent->platform().','.$agent->browser().$agent->version($agent->browser());
       $data = ['key'=>'dashboard_destroy_opportunitiess_ids_['.json_encode($request->ids).']','text'=>'Destroy selected opportunities Info','browser'=>$agent];

        DoFire::MK_REPORT($data,Auth::id(),null,$request->ipinfo);

        if ($request->has('ids')) {
            $this->event->wherein('id',$request->ids)->delete();
        }else{
        $this->event->truncate();
        }
        Session::flash('success',trans('home.message_success'));
        return redirect()->back();  
    }
}
