<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Requests\Admin\ServiceCategoryRequest;
use App\Http\Controllers\ImagesController;
use App\ServicesCategoryTranslations;
use Jenssegers\Agent\Agent;
use App\Helpers\DoFire;
use App\ServicesCategory;
use Auth;
use Session;

class ServicesCategoryController extends Controller
{
    
	public $view = 'panel.services_category.';
    
    public function __construct(ServicesCategory $model,ServicesCategoryTranslations $translation)
	{
        $this->model = $model;
        $this->translation = $translation;
	}

	public function index(Request $request,$category_id)
    {
    	$services = $this->model->where('category_id',$category_id)->get();
    	$agent = new Agent();
        $agent = $agent->platform().','.$agent->browser().$agent->version($agent->browser());
        $data = ['key'=>'dashboard_list_services','text'=>'List All Services','browser'=>$agent];
        DoFire::MK_REPORT($data,Auth::id(),null,$request->ipinfo);
    	return view($this->view.'index',compact('services'));
    }

   	public function create(Request $request,$category_id)
    {
    	$agent = new Agent();

        $agent = $agent->platform().','.$agent->browser().$agent->version($agent->browser());
        $data = ['key'=>'dashboard_create_new_service_view','text'=>'CreateNew Service View','browser'=>$agent];
        DoFire::MK_REPORT($data,Auth::id(),null,$request->ipinfo);
    	$category_id = $category_id;
    	$service = [];
    	return view($this->view.'create',compact('category_id','service'));
    }


    public function store(ServiceCategoryRequest $request,$category_id)
    {
    	if ($request->hasFile('icon')) {
    		$file = $request->file('icon');
    		$path = public_path().'/uploads/images/categories/services/'.date('o-m-d');
    		$db_path = '/uploads/images/categories/services/'.date('o-m-d');
    		$img = ImagesController::uploadSingle($file,$path,$db_path);
    	}else{
    		$img = '/img/unknown.png';
    	}


    	$create = $this->model->create([
    		'category_id'=>$request->category_id,
    		'img'=>$img,
    	]);

    		// dd($request->lang );
    	foreach ($request->lang as $key => $lang) {
	    	$translation = $this->translation->create([
	    		'title'=>$request->title[$key],
	    		'content'=>$request->content[$key],
	    		'lang_id'=>$lang,
	    		'service_id'=>$create->id
	    	]);
    	}

    	
    	$agent = new Agent();
    	$agent = $agent->platform().','.$agent->browser().$agent->version($agent->browser());
        $data = ['key'=>'dashboard_create_new_country','text'=>'Create New Country','browser'=>$agent];
        session::flash('success',trans('home.message_success'));
    	return redirect()->back();
    }

    public function edit($id,Request $request)
    {
    	$service  = $this->model->find($id);
    	$agent = new Agent();
        $agent = $agent->platform().','.$agent->browser().$agent->version($agent->browser());
        $data = ['key'=>'dashboard_edit_country_view_id:'.$id,'text'=>'dashboard edit country view ','browser'=>$agent];
        DoFire::MK_REPORT($data,Auth::id(),null,$request->ipinfo);
// dd($service->img);
    	return view($this->view.'edit',compact('service'));
    }


    public function update(ServiceCategoryRequest $request,$id)
    {
    	$service = $this->model->find($id);

    	if ($request->hasFile('icon')) {
    		$file = $request->file('icon');
    		$path = public_path().'/uploads/images/categories/services/'.date('o-m-d');
    		$db_path = '/uploads/images/categories/services/'.date('o-m-d');
    		$img = ImagesController::uploadSingle($file,$path,$db_path);
    	}else{
    		$img = $service->img;
    	}

    	$create = $this->model->find($id)->update([
    		'category_id'=>$service->category_id,
    		'img'=>$img,
    	]);
    	$this->translation->where('id',$id)->delete();
    	foreach ($request->lang as $key => $lang) {
	    	$translation = $this->translation->create([
	    		'title'=>$request->title[$key],
	    		'content'=>$request->content[$key],
	    		'lang_id'=>$lang,
	    		'service_id'=>$id
	    	]);
    	}

    	$agent = new Agent();
    	$agent = $agent->platform().','.$agent->browser().$agent->version($agent->browser());
        $data = ['key'=>'dashboard_update_country_id:'.$id,'text'=>'update Country','browser'=>$agent];
        session::flash('success',trans('home.message_success'));
    	return redirect()->back();
    }


    public function destroy($id,Request $request)
    {
    	$this->model->where('id',$id)->delete();

    	$agent = new Agent();
    	$agent = $agent->platform().','.$agent->browser().$agent->version($agent->browser());
        $data = ['key'=>'dashboard_update_country_id:'.$id,'text'=>'update Country','browser'=>$agent];
        session::flash('success',trans('home.message_success'));
    	return redirect()->back();
    }


    public function destroySelected(Request $request)
    {
    	$this->model->whereIn('id',$request->ids)->delete();
    	$agent = new Agent();
    	$agent = $agent->platform().','.$agent->browser().$agent->version($agent->browser());
        $data = ['key'=>'dashboard_delete_countres:','text'=>'Delte Countries','browser'=>$agent];
        session::flash('success',trans('home.message_success'));
    	return redirect()->back();
    }

}
