<?php

namespace App\Http\Controllers\Api\Auth;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Resources\Api\UserInfoResource;
use Carbon\Carbon;
use App\User;
use Validator;
use Response;
use Hash;
use Auth;


class SignupController extends Controller
{
    
    public function validation($request)
    {
         $validator = Validator::make($request, [
            'name' => ['required', 'string', 'max:255'],
            'password' => ['required', 'min:8'],
            'email' => ['required', 'string', 'email', 'max:255', 'unique:users'],
            'terms' => ['required'],
        ]);

        if ($validator->fails()) {
            $msg = $validator->errors()->first();
            $response = [
                    'success'=>FALSE,
                    'message'=>$msg,
                    'data'=>[]
                ];   
               return $response;  
        }
    }

    public function Signup(Request $request)
    {
    	$validation = $this->validation($request->all());
      
        if($validation != null){
            return Response::json($validation,400) ; 
        }

 		 $user = User::create([
		            'fname' => $request['name'],
		            'email' => $request['email'],
		            'password' => Hash::make($request['password']),
		        ]);
        $info = new  UserInfoResource(User::find($user->id));
        $tokenResult = $info->createToken('Personal Access Token');
 		$msg = 'success';
        $response = [
                'message'=>$msg,
                'success'=>TRUE,
                'data'=>[
                'user'=>$info,
                'access_token' => $tokenResult->accessToken,
                'token_type' => 'Bearer',
                'expires_at' => Carbon::parse(
                    	$tokenResult->token->expires_at
               		)->toDateTimeString()
                ]
                
            ];   
           return Response::json($response,200); 


    }
}
