<?php

namespace App\Http\Controllers\Api;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Resources\Api\FavResource;
use App\Fav;
use Response;
use Auth;
use Session;
class FavAdsController extends Controller
{
    public function __construct(Fav $fav)
	{
        $this->fav = $fav;
	}

	/*
	*************
	* Web Site  *
	************
	**/
	public function fav($ad_id,$user_id)
	{
		// $data = Auth::id();
		$find_fav = $this->fav->where('ad_id',$ad_id)->where('user_id',$user_id)->first();

		if ($find_fav !== null) {
			$fav = $this->fav->where('ad_id',$ad_id)->where('user_id',$user_id)->delete();
			$msg = "UnFav";

		}else{
			$fav = $this->fav->create([
				'user_id'=>$user_id,
				'ad_id'=>$ad_id,
			]);
			$msg = "Fav";
		}
		$code = 200;
        $response = ["status" => $code,'message'=>$msg,'data'=>$find_fav];
        Session::flash('success',trans('home.message_success'));

        // return Response::json($response,$code);
        return redirect()->back();
	}
	/**
	***************
	* Mobile Api  *
	***************
	**/
	public function MobileFav($ad_id)
	{
		$find_fav = $this->fav->where('ad_id',$ad_id)->where('user_id',Auth::id())->first();

		if ($find_fav !== null) {
			$fav = $this->fav->where('ad_id',$ad_id)->where('user_id',Auth::id())->delete();
			$msg = "UnFav";

		}else{
			$fav = $this->fav->create([
				'user_id'=>Auth::id(),
				'ad_id'=>$ad_id,
			]);
			$msg = "Fav";
		}	

			$favs = $this->fav->where('user_id',Auth::id())->get();
			$list = FavResource::collection($favs);

		  $response = [
                'message'=>$msg,
                'success'=>TRUE,
                'data'=>$list,                
            ];   
        return Response::json($response,200); 
	}


	public function FavList()
	{
		$favs = $this->fav->where('user_id',Auth::id())->get();
		$list = FavResource::collection($favs);
		$msg = "success";
	    $response = [
            'message'=>$msg,
            'success'=>TRUE,
            'data'=>$list,                
        ];   
        return Response::json($response,200); 
	}
	
}
