<?php

namespace App\Http\Controllers\Api;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Resources\Api\AdsResource;
use App\Ads,App\Category;
use Response;

class SearchController extends Controller
{
    public function search(Request $request,$category_id)
    {
    	$ads = Ads::where('category_id',$category_id)->get();
    	if($request->has('category_id')){

    		$ads = $ads->where('status','show')->where('category_id',$category_id);

    	}elseif( $request->has('type_ad')){

    		$ads = $ads->where('status','show')->where('type_ad',$request->type_ad);

    	}elseif ($request->has('category_id')  && $request->has('type_ad')) {
            
            $ads = $ads->where('status','show')->where('category_id',$category_id)->where('type_ad',$request->type_ad);
        }
        $category = Category::find($category_id);
        $ads = AdsResource::collection($ads);
        $msg = "success";
    	$response = [
                    'success'=>TRUE,
                    'message'=>$msg,
                    'data'=>$ads
                ];   
        return Response::json($response,200) ; 
    }
}
