@extends('front.layouts.main')
@section('meta_tags')
    <title>تسجيل الدخول | {{@$setting->translation->title}}</title>
    <meta name='description' itemprop='description' content='{!! @$info->translation->content!!}' />
    <meta name='keywords' content='{!!@$setting->meta_tags!!},{!!@$info->translation->title !!},{!!@$info->mission !!},{!!@$info->goals!!}' />
    <meta property="og:description"content="{{ @$info->translation->content }}" />
    <meta property="og:title"content="تسجيل الدخول  | {{@$setting->translation->title}} " />
    <meta property="og:url"content="{{URL::to('/about_us')}}" />
    <meta property="og:site_name"content="{{@$setting->translation->title}}" />
    <meta property="og:image" content="{{URL::to('/').@$setting->logo}}">

    <meta name="twitter:card"content="summary" />
    <meta name="twitter:title"content="تسجيل الدخول  | {{@$setting->translation->title}}" />
    <meta name="twitter:site"content="@wait" />
@stop
@section('content')

     <!--Contents-->
    <main class="inner-pages">
        <div class="inner-header">
            <div class="page-title">
                <div class="container">
                    <h5 class=""><a href="{{ url(LaravelLocalization::getCurrentLocale()) }}">@lang('home.home')</a> / @lang('home.signup')</h5>
                </div>
            </div>
        </div>
        <!-- ======================== start about =========================== -->
        <section class="contact section-padding">
            <div class="container">
                <div class="section-head text-center">
                    <h2>@lang('home.signup')</h2>
                </div>
                <ul class="nav nav-tabs justify-content-center" id="myTab" role="tablist">
                    <li class="nav-item">
                        <a class="nav-link active" id="personal-tab" data-toggle="tab" href="#personal" role="tab"
                            aria-controls="personal" aria-selected="true">شخصى</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" id="agency-tab" data-toggle="tab" href="#agency" role="tab"
                            aria-controls="agency" aria-selected="false">شركه</a>
                    </li>
                </ul>
                <div class="tab-content" id="myTabContent">
                    <div class="tab-pane fade show active" id="personal" role="tabpanel" aria-labelledby="personal-tab">
                        <div class="login">
                            <div class="row">
                                <div class="col-lg-10 offset-lg-1">
                                    <div class="contact-form contact-box">
                                        <form method="POST" action="{{ route('register') }}">
                                            @csrf
                                            <input type="hidden" name="user_type" value="user">
                                            @if(Session('success'))
                                            <div class="alert alert-success alert-dismissible">
                                                <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
                                                <strong>@lang('home.success')!</strong> {{session('success')}}.
                                            </div>
                                            @endif            
                                            @if ($errors->any())
                                            <div class="alert alert-danger">
                                                <ul>
                                                    @foreach ($errors->all() as $error)
                                                    <li>{{ $error }}</li>
                                                    @endforeach
                                                </ul>
                                            </div>
                                            @endif
                                            <div class="form-row">
                                                <div class="col-md-6">
                                                    <input class="form-control" name="name" type="text" placeholder="@lang('home.name')" value="{{ Request::old('name') }}" required>
                                                </div>
                                                <div class="col-md-6">
                                                    <input class="form-control" name="email" value="{{ Request::old('email')  }}" type="text" placeholder="@lang('home.email')">
                                                </div>
                                                <div class="col-md-6">
                                                   <input class="form-control" name="phone" type="text" value="{{ Request::old('phone') }}" placeholder="@lang('home.phone')">
                                                </div>
                                                <div class="col-md-6">
                                                     <input class="form-control" name="job_title" type="text" required  value="{{ Request::old('address') }}" placeholder="@lang('home.job_title')">
                                                </div>
                                                <div class="col-md-12">
                                                    <input class="form-control" name="governmental_id" type="text" value="{{ Request::old('governmental_id') }}" placeholder="@lang('home.governmental_id')">
                                                </div>
                                              
                                                <div class="col-md-6">
                                                    <select name="country_id" class="form-control">
                                                    <option value="">@lang('home.nationality')</option>
                                                    @foreach($countries as $country)
                                                        <option value="{{ @$country->id }}" @if($country->id == Request::old('country_id')) selected @endif>{{ @$country->translations->where('lang_id',$active_lang->id)->first()->name }}</option>
                                                    @endforeach
                                                    </select>
                                                </div>

                                                <div class="col-md-6">
                                                  <select name="city_id" class="form-control">
                                                    <option value="">@lang('home.cities')</option>
                                                    @foreach($cities as $city)
                                                    <option value="{{ @$city->id }}" @if($city->id == Request::old('city_id')) selected @endif>{{ @$city->translations->where('lang_id',$active_lang->id)->first()->name }}</option>
                                                    @endforeach
                                                </select>
                                                </div> 

                                                <div class="col-md-6">
                                                     <input class="form-control" name="address" type="text" required  value="{{ Request::old('address') }}" placeholder="@lang('home.address')">
                                                </div>
                                                 <div class="col-md-6">
                                                    <select name="gander" class="form-control">
                                                        <option value="">@lang('home.gander')</option>
                                                        <option value="male" >@lang('home.male')</option>
                                                        <option value="female" >@lang('home.female')</option>
                                                    </select>
                                                </div>       
                                                 <div class="col-md-6">
                                                    <input class="form-control" name="password" type="password" placeholder="@lang('home.password')">
                                                </div>
                                                <div class="col-md-6">
                                                    <input class="form-control" name="password_confirmation" type="password" placeholder="@lang('home.password_confirmation')">
                                                </div>
                                               {{--  <div class="col-md-12">
                                                    <div class="file">
                                                        <input class="form-control" type="file" name="image">
                                                        <span>صورة الملف الشخصي</span>
                                                    </div>
                                                </div> --}}
                                              {{--   <div class="col-md-6">
                                                    <div class="file">
                                                        <input class="form-control" type="file" name="myFile">
                                                        <span>الشهادات الحاصل عليها</span>
                                                    </div>
                                                </div> --}}
                                                
                                                <div class="col-md-12">
                                                    <div class="custom-control custom-checkbox">
                                                        <input type="checkbox" class="custom-control-input"
                                                            id="customCheck1" name="terms">
                                                        <label class="custom-control-label" for="customCheck1">
                                                            <p>@lang('home.accept_the_terms_and_conditions')</p>
                                                        </label>
                                                    </div>
                                                </div>
                                            </div>
                                            <button type="submit" class="butn"><span>@lang('home.send')</span></button>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="tab-pane fade" id="agency" role="tabpanel" aria-labelledby="agency-tab">
                        <div class="login">
                            <div class="row">
                                <div class="col-lg-10 offset-lg-1">
                                    <div class="contact-form contact-box">
                                       <form method="POST" action="{{ route('register') }}">
                                            @csrf
                                            <input type="hidden" name="user_type" value="companies">
                                            @if(Session('success'))
                                            <div class="alert alert-success alert-dismissible">
                                                <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
                                                <strong>@lang('home.success')!</strong> {{session('success')}}.
                                            </div>
                                            @endif            
                                            @if ($errors->any())
                                            <div class="alert alert-danger">
                                                <ul>
                                                    @foreach ($errors->all() as $error)
                                                    <li>{{ $error }}</li>
                                                    @endforeach
                                                </ul>
                                            </div>
                                            @endif
                                            <div class="form-row">
                                                <div class="col-md-6">
                                                    <input class="form-control" name="name" type="text" placeholder="@lang('home.name')" value="{{ Request::old('name') }}" required>
                                                </div>
                                                <div class="col-md-6">
                                                    <input class="form-control" name="email" value="{{ Request::old('email')  }}" type="text" placeholder="@lang('home.email')">
                                                </div>
                                                <div class="col-md-6">
                                                   <input class="form-control" name="phone" type="text" value="{{ Request::old('phone') }}" placeholder="@lang('home.phone')">
                                                </div>
                                                <div class="col-md-6">
                                                     <input class="form-control" name="job_title" type="text" required  value="{{ Request::old('address') }}" placeholder="@lang('home.job_title')">
                                                </div>
                                                <div class="col-md-6">
                                                    <input class="form-control" name="governmental_id" type="text" value="{{ Request::old('governmental_id') }}" placeholder="@lang('home.governmental_id')">
                                                </div>
                                                <div class="col-md-6">
                                                    <input class="form-control" name="commercial_register" type="text"  value="{{ @Request::old('commercial_register') }}" placeholder="@lang('home.commercial_register')">
                                                </div>
                                               
                                              
                                                <div class="col-md-6">
                                                    <select name="country_id" class="form-control">
                                                    <option value="0">@lang('home.nationality')</option>
                                                    @foreach($countries as $country)
                                                        <option value="{{ @$country->id }}" @if($country->id == Request::old('country_id')) selected @endif>{{ @$country->translations->where('lang_id',$active_lang->id)->first()->name }}</option>
                                                    @endforeach
                                                    </select>
                                                </div>

                                                <div class="col-md-6">
                                                  <select name="city_id" class="form-control">
                                                    <option value="0">@lang('home.cities')</option>
                                                    @foreach($cities as $city)
                                                    <option value="{{ @$city->id }}" @if($city->id == Request::old('city_id')) selected @endif>{{ @$city->translations->where('lang_id',$active_lang->id)->first()->name }}</option>
                                                    @endforeach
                                                </select>
                                                </div> 

                                                <div class="col-md-6">
                                                     <input class="form-control" name="address" type="text" required  value="{{ Request::old('address') }}" placeholder="@lang('home.address')">
                                                </div>
                                                 <div class="col-md-6">
                                                    <select name="gander" class="form-control">
                                                        <option value="">@lang('home.gander')</option>
                                                        <option value="male" >@lang('home.male')</option>
                                                        <option value="female" >@lang('home.female')</option>
                                                    </select>
                                                </div>       
                                                 <div class="col-md-6">
                                                    <input class="form-control" name="password" type="password" placeholder="@lang('home.password')">
                                                </div>
                                                <div class="col-md-6">
                                                    <input class="form-control" name="password_confirmation" type="password" placeholder="@lang('home.password_confirmation')">
                                                </div>
                                               {{--  <div class="col-md-12">
                                                    <div class="file">
                                                        <input class="form-control" type="file" name="image">
                                                        <span>صورة الملف الشخصي</span>
                                                    </div>
                                                </div> --}}
                                              {{--   <div class="col-md-6">
                                                    <div class="file">
                                                        <input class="form-control" type="file" name="myFile">
                                                        <span>الشهادات الحاصل عليها</span>
                                                    </div>
                                                </div> --}}
                                                
                                                <div class="col-md-12">
                                                    <div class="custom-control custom-checkbox">
                                                        <input type="checkbox" class="custom-control-input"
                                                            id="customCheck1" name="terms">
                                                        <label class="custom-control-label" for="customCheck1">
                                                            <p>@lang('home.accept_the_terms_and_conditions')</p>
                                                        </label>
                                                    </div>
                                                </div>
                                            </div>
                                            <button class="butn" type="submit"><span>@lang('home.send')</span></button>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </main>
    <!--End-Contents-->
@stop
