@extends('front.layouts.main')
@section('meta_tags')
    <title>@lang('home.about_us') | {{@$setting->translation->title}}</title>
    <meta name='description' itemprop='description' content='{!! @$info->translation->content!!}' />
    <meta name='keywords' content='{!!@$setting->meta_tags!!},{!!@$info->translation->title !!},{!!@$info->mission !!},{!!@$info->goals!!}' />
    <meta property="og:description"content="{{ @$info->translation->content }}" />
    <meta property="og:title"content="@lang('home.about_us') | {{@$setting->translation->title}} " />
    <meta property="og:url"content="{{URL::to('/about_us')}}" />
    <meta property="og:site_name"content="{{@$setting->translation->title}}" />
    <meta property="og:image" content="{{URL::to('/').@$setting->logo}}">

    <meta name="twitter:card"content="summary" />
    <meta name="twitter:title"content="@lang('home.about_us')| {{@$setting->translation->title}}" />
    <meta name="twitter:site"content="@wait" />
@stop
@section('content')
  <!--Contents-->
    <main class="inner-pages">
        <div class="inner-header">
            <div class="page-title">
                <div class="container">
                    <h5 class=""><a href="#">@lang('home.home')</a> / @lang('home.about_us')</h5>
                </div>
            </div>
        </div>
        
        <!-- ======================== start about =========================== -->
        <section class="about section-padding">
            <div class="container">
                <div class="section-head text-center">
                    <br>
                    <h2>@lang('home.about_us')</h2>
                </div>

                <div class="row">
                    <div class="col-lg-6 valign">
                        <div class="items wow fadeInRight">
                            <div class="info">
                                @if($info != null)
                                <h2>{{ @$info->translations->where('lang_id',$active_lang->id)->first()->title }}</h2>
                                <p>{{ $info->translations->where('lang_id',$active_lang->id)->first()->content }}</p>
                                @endif
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-6">
                        <div class="items wow zoomIn">
                            <div class="img">
                                @if($info != null)
                                <img src="{{ @asset($info->image) }}" alt="">
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row section-padding about-video">
                    <div class="col-lg-6">
                        <div class="vid">
                            @if($info != null)
                            <iframe width="460" height='400' src="{{str_replace(' ','',str_replace('https://youtu.be/', 'https://www.youtube.com/embed/', $info->vedio_url)) }}" frameborder="0" allow="autoplay; encrypted-media" allowfullscreen></iframe>
                            @endif
                        </div>
                    </div>
                    @if($info != null)
                    <div class="col-lg-6 valign">
                        <div class="info">
                            <h2>@lang('home.who_we_are_working')</h2>
                            <p>{{ @$info->translations->where('lang_id',$active_lang->id)->first()->who_we_are_working }}</p>
                        </div>
                    </div>
                    @endif
                </div>

                <div class="row section-padding massion">
                    @if($info != null)
                    <div class="row">
                        <div class="col-lg-6">
                            <div class="info">
                                <h2>@lang('home.mission') </h2>
                                <p>{{ @$info->translations->where('lang_id',$active_lang->id)->first()->mission }}</p>
                            </div>
                        </div>
                        <div class="col-lg-6">
                            <div class="info">
                                <h2>@lang('home.vision') </h2>
                                <p>{{ @$info->translations->where('lang_id',$active_lang->id)->first()->goals }}</p>
                            </div>
                        </div>
                    </div>
                    @endif
                </div>
            </div>
        </section>
  
    </main>
    <!--End-Contents-->
@stop