@extends('front.layouts.main')
@section('meta_tags')
    <title>@lang('home.contactus') | {{@$setting->translation->title}}</title>
    <meta name='description' itemprop='description' content='{!! @$info->translation->content!!}' />
    <meta name='keywords' content='{!!@$setting->meta_tags!!},{!!@$info->translation->title !!},{!!@$info->mission !!},{!!@$info->goals!!}' />
    <meta property="og:description"content="{{ @$info->translation->content }}" />
    <meta property="og:title"content="@lang('home.contactus') | {{@$setting->translation->title}} " />
    <meta property="og:url"content="{{URL::to('/about_us')}}" />
    <meta property="og:site_name"content="{{@$setting->translation->title}}" />
    <meta property="og:image" content="{{URL::to('/').@$setting->logo}}">

    <meta name="twitter:card"content="summary" />
    <meta name="twitter:title"content="@lang('home.contactus')| {{@$setting->translation->title}}" />
    <meta name="twitter:site"content="@wait" />
@stop
@section('content')
  <!--Contents-->
    <main class="inner-pages">
        <div class="inner-header">
            <div class="page-title">
                <div class="container">
                    <h5 class=""><a href="{{ url(LaravelLocalization::getCurrentLocale()) }}">@lang('home.home')</a> / @lang('home.contactus')</h5>
                </div>
            </div>
        </div>
        
         <!-- ======================== start about =========================== -->
        <section class="contact section-padding">
            <div class="container">
                <div class="section-head text-center">
                    <small>يسعدنا ان </small>
                    <br>
                    <h2>تتواصل معنا الان</h2>
                </div>
                <div class="contact-box">
                    <div class="row">
                        <div class="col-lg-5">
                            <div class="contact-info">
                                <h4>لاتتردد في التحدث معنا</h4>
                                <p>{{ @$setting->translations->where('lang_id',$active_lang->id)->first()->content }}</p>
                                <ul>
                                    @foreach($setting->address as $address)
                                    <li>{{ @$address->address_ar }}<span><img src="{{ asset('site/images/loc.svg') }}" alt=""></span></li>
                                    @endforeach
                                    @foreach($setting->emails as $email)
                                    <li>{{ @@$email->email  }}<span><img src="{{ asset('site/images/email.svg') }}" alt=""></span></li>
                                    @endforeach
                                    @foreach($setting->phones as $phone)
                                       
                                        <li title="@lang('home.phone')">{{ @$phone->phone }}<span><img src="{{ asset('site/images/call.svg') }}" alt=""></span></li>
                                    @endforeach
                                     @foreach($setting->whatsapp as $whatsapp)
                                       
                                        <li title="@lang('home.whatsapp')">{{ @$whatsapp->whatsapp }}<span><img src="{{ asset('site/images/call.svg') }}" alt=""></span></li>
                                    @endforeach

                                </ul>

                                <div class="social-icons">
                                    @foreach($setting->social_media_link as $link)
                                    <a href="{{ @$link->url }}"><img src="{{ asset($link->icon) }}"></a>
                                    @endforeach
                                  {{--   <a href="#"><i class="fab fa-facebook-f"></i></a>
                                    <a href="#"><i class="fab fa-instagram"></i></a>
                                    <a href="#"><i class="fab fa-twitter"></i></a>
                                    <a href="#"><i class="fab fa-linkedin-in"></i></a> --}}
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-7">
                            <div class="contact-form">
                                <form action="{{ url('/contactus') }}" method="post">
                                 @csrf
                                 @if ($errors->any())
                                 @foreach ($errors->all() as $error)
                                 <div class="alert alert-danger alert-dismissible">
                                    {{ $error }}
                                    <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
                                </div>
                                @endforeach
                                @endif
                                @if(Session::has('success'))
                                <div class="alert alert-success alert-dismissible">
                                    <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>{{ Session::get('success') }}
                                </div>
                                @endif
                                    <div class="form-row">
                                        <div class="col-md-6">
                                            <input type="text" name="name"  class="form-control" value="{{ Request::old('name') }}" placeholder="الاسم بالكامل">
                                        </div>
                                        <div class="col-md-6">
                                            <input type="email" name="email"  class="form-control" value="{{ Request::old('email') }}" id="" placeholder="البريد الالكترونى">

                                        </div>
                                        <div class="col-md-6">
                                           <input type="text" name="subject"  class="form-control" value="{{ Request::old('subject') }}"  placeholder="الموضوع">

                                        </div>
                                        <div class="col-md-6">
                                            <input type="text" name="phone"  class="form-control" value="{{ Request::old('phone') }}" placeholder="رقم الهاتف">

                                        </div>
                                        <div class="col-12">
                                             <textarea name="message"  class="form-control" id="" placeholder="رسالتك"> {{ Request::old('message') }} </textarea>
                                        </div>
                                    </div>
                                    <button class="butn"><span>أرسال</span></button>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
  
    </main>
    <!--End-Contents-->
@stop