@extends('front.layouts.main')
@section('meta_tags')
    <title>@lang('home.home') | {{@$setting->translation->title}}</title>
    <meta name='description' itemprop='description' content='{!! @$info->translation->content!!}' />
    <meta name='keywords' content='{!!@$setting->meta_tags!!},{!!@$info->translation->title !!},{!!@$info->mission !!},{!!@$info->goals!!}' />
    <meta property="og:description"content="{{ @$info->translation->content }}" />
    <meta property="og:title"content="@lang('home.home')  | {{@$setting->translation->title}} " />
    <meta property="og:url"content="{{URL::to('/about_us')}}" />
    <meta property="og:site_name"content="{{@$setting->translation->title}}" />
    <meta property="og:image" content="{{URL::to('/').@$setting->logo}}">

    <meta name="twitter:card"content="summary" />
    <meta name="twitter:title"content="@lang('home.home') | {{@$setting->translation->title}}" />
    <meta name="twitter:site"content="@wait" />
@stop
@section('content')
    <!--Header-->
    @if($sliders->count() > 0)
    <header>
        <div class="owl-carousel owl-theme">
            @foreach($sliders as $slider)
            <div class="items" style="background-image: url({{asset('/').$slider->img}});">
                <div class="content valign">
                    <div class="container">
                        <div class="row">
                            <div class="col-lg-8 offset-lg-2">
                                <div class="info text-center animated fadeInUp">
                                    <h1>{{@$slider->translations->where('lang_id',$active_lang->id)->first()->title}}</h1>
                                    <p> {{@$slider->translations->where('lang_id',$active_lang->id)->first()->content}}</p>
                                    <a href="{{@$slider->visit_url}}" target="_blank" class="butn animated zoomIn"><span>@lang('home.visit_url')</span></a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            @endforeach

        </div>
    </header>
    @endif
    <!--End-Header-->
    <!--Contents-->
    <main>
        <!-- ======================== start services =========================== -->
       <!-- ======================== start services =========================== -->
        <section class="services section-padding">
            <div class="container">
                <div class="section-head text-center">
                    <br>
                    <h2>@lang('home.services') </h2>
                </div>
                <div class="row">
                   @if($categories->count()> 0 )
                   @foreach($categories as $category)
                    <div class="col-lg-6">
                        <div class="items text-center wow fadeInUp">
                            <a href="#0" class="filter-nav" data-content=".box{{ @$category->id }}">
                                <div class="img">
                                    <img src="{{ @asset($category->icon) }}" alt="">
                                </div>
                                <h2>{{ @$category->translations->where('lang_id',$active_lang->id)->first()->name }}</h2>
                                <p> {{ @$category->translations->where('lang_id',$active_lang->id)->first()->content }}
                                </p>
                            </a>
                        </div>
                    </div>
                    @endforeach
                    @endif

                 
                </div>
            </div>
            <div class="contain">
                @if($categories->count()> 0 )
                @foreach($categories as $category)
                <div class="services-slider box{{ @$category->id }}">
                @if($category->services != null )
                 @foreach($category->services as $service)
                 <div class="items text-center">
                    <div class="icon">
                        <img src="{{ @asset($service->img) }}" alt="">
                    </div>
                    <h5>{{ @$service->translations->where('lang_id',$active_lang->id)->first()->title }}</h5>
                    <p> {{ @$service->translations->where('lang_id',$active_lang->id)->first()->content }}        </p>
                </div>
                @endforeach
                @endif

                </div>
                @endforeach
                @endif


        </section>
        <!-- ======================== start about =========================== -->
        <section class="about section-padding">
            <div class="container">
                <div class="section-head text-center">
                    <br>
                    <h2>@lang('home.about_us')</h2>
                </div>

                @if($info != null)
                <div class="row">
                    <div class="col-lg-6 valign">
                        <div class="items wow fadeInRight">
                            <div class="info">
                                <h2>{{ @$info->translations->where('lang_id',$active_lang->id)->first()->title }}</h2>
                                <p>{{ @$info->translations->where('lang_id',$active_lang->id)->first()->content }}</p>
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-6">
                        <div class="items wow zoomIn">
                            <div class="img">
                                <img src="{{asset($info->image)}}" alt="">
                            </div>
                        </div>
                    </div>
                </div>
                @endif
            </div>
        </section>
        <!-- ======================== start video =========================== -->
    
        <!-- ======================== start video =========================== -->
        <section class="video section-padding wow fadeInUp">
            <div class="container">
                <div class="text-center">
                    <!-- <a href="images/vid.mp4" class="vid"><img src="images/play-button.png" alt=""></a> -->
                    <button type="button" class="btn" data-toggle="modal" data-target="#exampleModalCenter">
                        <img src="{{ asset('site/images/play-button.png') }}" alt="">
                    </button>
                </div>
            </div>
            <!-- Modal -->
            <div class="modal fade" id="exampleModalCenter" tabindex="-1" role="dialog"
                aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered" role="document">
                    <div class="modal-content">
                        
                        <div class="modal-body">
                            <iframe width="100%" height="350" src="{{@str_replace(' ','',@str_replace('https://youtu.be/', 'https://www.youtube.com/embed/', @$info->vedio_url)) }}"
                                frameborder="0"
                                allow="accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture"
                                allowfullscreen></iframe>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- ======================== start clients =========================== -->
        <section class="clients section-padding">
            <div class="container">
                <div class="section-head text-center">
                    <h2>@lang('home.partners')</h2>
                </div>
                <div class="content owl-carousel owl-theme wow zoomIn">
                  @foreach(@$testmonials as $testmonial)
                    <div class="img">
                        <img src="{{@asset($testmonial->image)}}" alt="">
                    </div>
                    @endforeach

     {{--                <div class="img">
                        <img src="{{asset('/site')}}/images/clients/2.jpg" alt="">
                    </div>
                    <div class="img">
                        <img src="{{asset('/site')}}/images/clients/3.jpg" alt="">
                    </div>
                    <div class="img">
                        <img src="{{asset('/site')}}/images/clients/4.jpg" alt="">
                    </div>
                    <div class="img">
                        <img src="{{asset('/site')}}/images/clients/5.jpg" alt="">
                    </div>
                    <div class="img">
                        <img src="{{asset('/site')}}/images/clients/6.jpg" alt="">
                    </div> --}}
                </div>
            </div>
        </section>
    </main>
    <!--End-Contents-->
   @stop