<!DOCTYPE html>

<html>

<head>
    {{-- <title> Shorkaa | Home</title> --}}
    @yield('meta_tags')

    <meta charset="utf-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
    <meta name="description" content="" />
    <meta name="keywords" content="" />
    <meta name="author" content="Hossam H-Coder7" />
    <link rel="shortcut icon" href="{{asset('/site')}}/images/favicon.ico" title="Favicon" sizes="16x16" />
    @if(LaravelLocalization::getCurrentLocale() == 'en')
        <link rel="stylesheet" href="{{asset('/site')}}/css/lib/bootstrap-ltr.min.css">
    @else
        <link rel="stylesheet" href="{{asset('/site')}}/css/lib/bootstrap-rtl.min.css" />
    @endif
    <link rel="stylesheet" href="{{asset('/site')}}/css/lib/animate.css" />
    <link rel="stylesheet" href="{{asset('/site')}}/css/lib/swiper.css" />

    <link rel="stylesheet" href="{{asset('/site')}}/css/lib/all.min.css" />
    <link rel="stylesheet" href="{{asset('/site')}}/css/lib/owl.carousel.min.css" />
    <link rel="stylesheet" href="{{asset('/site')}}/css/lib/owl.theme.default.min.css" />
    <link rel="stylesheet" href="{{asset('/site')}}/css/lib/jquery.fancybox.css" />
    <link rel="stylesheet" href="{{asset('/site')}}/css/lib/magnific-popup.css" />
    @if(LaravelLocalization::getCurrentLocale() == 'en')
    <link rel="stylesheet" href="{{asset('/site')}}/css/styles.css" />

        <link rel="stylesheet" href="{{asset('/site')}}/css/style_en.css" />
    @else
    <link rel="stylesheet" href="{{asset('/site')}}/css/styles.css" />
    @endif
    <!-- <link rel="stylesheet" href="css/style_en.css"> -->

    <!--[if it IE 9]>
      <script src="{{asset('/site')}}/js/lib/html5shiv.min.js"></script>
      <script src="{{asset('/site')}}/js/lib/respond.min.js"></script>
    <![endif]-->

</head>

<body>
    <!--Menu-->
    <div class="menu">
        <nav class="custom-navbar">
            <div class="container">
                <div class="row">
                    <div class="col-lg-2">
                        <div class="logo">
                            <a class="navbar-brand" href="{{ url(LaravelLocalization::getCurrentLocale()) }}">

                                @if($setting !== null)
                                @if($setting->logo !== null)
                                <img src="{{asset($setting->logo)}}" alt="">
                                @else
                                <img src="{{asset('site/images/logo.png')}}" alt="">
                                @endif
                                @endif
                            </a>
                            <div class="nav-toggle">
                                <span></span>
                                <span></span>
                                <span></span>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-10">

                        <ul class="nav-list">
                            <li>
                                <div class="mob-logo">
                                    <span>
                                        @if($setting !== null)
                                        @if($setting->logo !== null)
                                        <img src="{{asset($setting->logo)}}" alt="">
                                        @else
                                        <img src="{{asset('site/logo.png')}}" alt="">
                                        @endif
                                        @endif
                                    </span>
                                    <span class="cls"><i class="far fa-times-circle"></i></span>
                                </div>
                            </li>
                            <li class="nav-items"><a class="nav-links" href="{{url(LaravelLocalization::getCurrentLocale())}}">@lang('home.home')</a></li>
                            <li class="nav-items"><a class="nav-links" href="{{url(LaravelLocalization::getCurrentLocale().'/about_us')}}">@lang('home.about_us')</a></li>
                            @if($categories->count()> 0 )
                           @foreach($categories as $category)
                            <li class="nav-items"><a class="nav-links" href="{{url(LaravelLocalization::getCurrentLocale()).'/category/'.@$category->id.'/'.@str_replace(' ','_',@$category->translations->where('lang_id',$active_lang->id)->first()->name)}}">{{@$category->translations->where('lang_id',$active_lang->id)->first()->name}}</a></li>
                            @endforeach
                            @endif
                            <li class="nav-items drop-nav">
                                <a class="nav-links" href="#0">@lang('home.pages')</a>
                                <ul class="drop-down">
                                    <li>
                                        <a href="{{ url(LaravelLocalization::getCurrentLocale().'/contact') }}">@lang('home.contactus')</a>
                                    </li>
                                    @if($pages->count()> 0 )
                                    @foreach($pages as $page)
                                    <li>
                                        <a href="{{ url(LaravelLocalization::getCurrentLocale().'/page/'.$page->id.'/'.@$page->url) }}">{{ @$page->translations->where('lang_id',$active_lang->id)->first()->title }}</a>
                                    </li>
                                    @endforeach
                                    @endif
                                </ul>
                            </li>  
                        
                            <li class="nav-items"><a class="nav-links" href="{{ url(LaravelLocalization::getCurrentLocale().'/contact') }}">@lang('home.contactus')</a></li>
                            @if(Auth::check())
                            <li class="nav-items drop-nav">
                                <a class="nav-links" href="#0">@lang('home.profile')</a>
                                <ul class="drop-down">
                                    <li><a href="{{ url(LaravelLocalization::getCurrentLocale()).'/user/profile/'.Auth::id().'/'.str_replace(' ', '-', str_replace(' ', '-', Auth::user()->fname).'-'.str_replace(' ', '-', Auth::user()->lname).'-'.str_replace(' ', '-', Auth::user()->family_name)) }}">@lang('home.profile')</a></li>
                                    <li><a href="{{ url(LaravelLocalization::getCurrentLocale()).'/ads/create' }}">@lang('home.create_ad')</a></li>
                                    <li><a href="{{ url(LaravelLocalization::getCurrentLocale()).'/groups/create' }}">@lang('home.create_group')</a></li>
                                    <li><a href="{{ URL::to('/logout') }}"> @lang('home.logout')</a></li>
                                </ul>
                            </li>
                            @else
                            <li class="nav-items drop-nav">
                                <a class="nav-links" href="#0">@lang('home.more')</a>
                                <ul class="drop-down">
                                    <li><a href="{{ url(LaravelLocalization::getCurrentLocale()).'/login' }}">@lang('home.login')</a></li>
                                    <li><a href="{{ url(LaravelLocalization::getCurrentLocale()).'/register' }}">@lang('home.signup')</a></li>
                                </ul>
                            </li>
                            @endif
                        </ul>

                    </div>
                </div>
            </div>
        </nav>
    </div>
    <!--End-Menu-->
    @yield('content')


 <!--Footer-->
    <footer class="section-padding text-center section-padding">
        <div class="container">
            <div class="row">
                <div class="col-lg-3">
                    <div class="items">
                        <h5>@lang('home.important_url')</h5>
                        <p><a href="{{url(LaravelLocalization::getCurrentLocale())}}">@lang('home.home')</a> </p>
                        <p><a href="{{url(LaravelLocalization::getCurrentLocale().'/about_us')}}">@lang('home.about_us')</a> </p>
                        {{-- <p><a href="#">رياده اعمال</a> </p> --}}
                        {{-- <p><a href="#">أجتماعى</a> </p> --}}
                        @if($categories->count()> 0 )
                        @foreach($categories as $category)
                        <p><a href="{{url(LaravelLocalization::getCurrentLocale()).'/category/'.@$category->id.'/'.@str_replace(' ','_',$category->translations->where('lang_id',$active_lang->id)->first()->name)}}">{{$category->translations->where('lang_id',$active_lang->id)->first()->name}}</a></p>
                        @endforeach
                        @endif
                        
                        <p><a href="{{ url(LaravelLocalization::getCurrentLocale().'/contact') }}">@lang('home.contactus')</a> </p>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="img">
                        @if($setting !== null)
                        @if($setting->logo !== null)
                        <img src="{{asset($setting->logo)}}" alt="">
                        @else
                        <img src="{{asset('site/logo.png')}}" alt="">
                        @endif
                        @endif
                    </div>
                    <p>{{ @$setting->translations->where('lang_id',$active_lang->id)->first()->content }}</p>
                </div>
                <div class="col-lg-3">
                    <div class="items socail">
                        <h5>@lang('home.contactus')</h5>
                        @foreach($setting->phones as $phone)
                        <p title="@lang('home.phone')">{{ @$phone->phone }}</p>
                        @endforeach

                        @foreach($setting->whatsapp as $whatsapp)
                        <p title="@lang('home.whatsapp')">{{ @$whatsapp->whatsapp }}</p>
                        @endforeach                       
                        @foreach($setting->emails as $email)
                        <p>{{ @$email->email }}</p>
                        @endforeach
                        {{-- <p>Example@gmail.com </p> --}}
                        @foreach($setting->address as $address)
                        <p>{{ @$address->address_ar }}</p>
                        @endforeach
                        <p>
                            @foreach($setting->social_media_link as $link)
                            <a href="{{ @$link->url }}"><img src="{{ asset($link->icon) }}"></a>
                            @endforeach
                            {{-- <a href="#"><i class="fab fa-twitter"></i></a> --}}
                            {{-- <a href="#"><i class="fab fa-instagram"></i></a> --}}
                        </p>
                    </div>
                </div>
            </div>
        </div>
        <div class="foot">
        </div>
    </footer>
    <!--End-Footer-->
    <!-- -------------- request ----------------- -->
    <a class="to-top" data-scroll href="#bazinga" id="scroll-btn">
        <i class="fa fa-arrow-up"></i>
    </a>
    <script src="{{asset('/site')}}/js/lib/jquery-1.12.3.min.js"></script>
    <script src="{{asset('/site')}}/js/lib/popper.min.js"></script>
    <script src="{{asset('/site')}}/js/lib/bootstrap.min.js"></script>
    <script src="{{asset('/site')}}/js/lib/wow.min.js"></script>
    <script src="{{asset('/site')}}/js/lib/jquery.fancybox.js"></script>
    <script src="{{asset('/site')}}/js/lib/jquery.easing-1.3.pack.js"></script>
    <script src="{{asset('/site')}}/js/lib/jquery.mousewheel-3.0.4.pack.js"></script>
    <script src="{{asset('/site')}}/js/lib/owl.carousel.min.js"></script>
    <script src="{{asset('/site')}}/js/lib/smooth-scroll.min.js"></script>
    <script src="{{asset('/site')}}/js/lib/jquery.nicescroll.min.js"></script>
    <script src="{{asset('/site')}}/js/lib/mixitup.min.js"></script>
    <script src="{{asset('/site')}}/js/lib/typed.min.js"></script>
    <script src="{{asset('/site')}}/js/lib/scrollIt.min.js"></script>
    <script src="{{asset('/site')}}/js/lib/jquery.waypoints.min.js"></script>
    <script src="{{asset('/site')}}/js/lib/jquery.counterup.js"></script>
    <script src="{{asset('/site')}}/js/lib/typed.js"></script>
    <script src="{{asset('/site')}}/js/lib/jquery.magnific-popup.min.js"></script>
    <script src="{{asset('/site')}}/js/lib/swiper.js"></script>

    <script src="{{asset('/site')}}/js/main.js"></script>
    @yield('jsCode')
    <script>
        var swiper = new Swiper('.swiper-container', {
            effect: 'cube',
            grabCursor: true,
            loop: true,
            cubeEffect: {
                shadow: true,
                slideShadows: true,
                shadowOffset: 20,
                shadowScale: 0.94,
            },
            autoplay: {
                delay: 2500,
                disableOnInteraction: false,
            },
            pagination: {
                el: '.swiper-pagination',
            },
        });
    </script>
</body>

</html>