@extends('front.layouts.main')
@section('meta_tags')
    <title>@lang('home.ads') | {{@$setting->translation->title}}</title>
    <meta name='description' itemprop='description' content='{!! @$info->translation->content!!}' />
    <meta name='keywords' content='{!!@$setting->meta_tags!!},{!!@$info->translation->title !!},{!!@$info->mission !!},{!!@$info->goals!!}' />
    <meta property="og:description"content="{{ @$info->translation->content }}" />
    <meta property="og:title"content="@lang('home.ads') | {{@$setting->translation->title}} " />
    <meta property="og:url"content="{{URL::to('/about_us')}}" />
    <meta property="og:site_name"content="{{@$setting->translation->title}}" />
    <meta property="og:image" content="{{URL::to('/').@$setting->logo}}">

    <meta name="twitter:card"content="summary" />
    <meta name="twitter:title"content="@lang('home.ads')| {{@$setting->translation->title}}" />
    <meta name="twitter:site"content="@wait" />
@stop
@section('content')
    <!--Contents-->
    <main class="inner-pages">
        <div class="inner-header">
            <div class="page-title">
                <div class="container">
                    <h5 class=""><a href="#">@lang('home.home')</a> / @lang('home.ads')/ @lang('home.create_ad')</h5>
                </div>
            </div>
        </div>
        <!-- ======================== start about =========================== -->
        <section class="contact section-padding">
            <div class="container">
                <div class="section-head text-center">
                    <h2>@lang('home.create_ad')</h2>
                </div>
                <div class="login">
                    <div class="row">
                        <div class="col-lg-8 offset-lg-2">
                            <div class="contact-form contact-box">
                            	<form class="form-horizontal form-validate-jquery" method="POST" action="{{ URL::to('/ads/store') }}" enctype='multipart/form-data'>
                            		@if ($errors->any())
                            		@foreach ($errors->all() as $error)
                            		<div class="alert alert-danger alert-dismissible" >
                            			<a href="#" class="close" data-dismiss="alert" aria-label="close" style="right: 5px;">&times;</a>{{@$error }}
                            		</div>
                            		@endforeach
                            		@endif
                            		@if(Session::has('success'))
                            		<div class="alert alert-success alert-dismissible">
                            			<a href="#" class="close" data-dismiss="alert" aria-label="close" style="right: 5px;">&times;</a>{{ Session::get('success') }}
                            		</div>
                            		@endif
                            		@csrf

                                    <div class="form-row">
                                    	<div class="col-md-6">
                                        <div class="">
                                            <select name="category_id" id="parent_id" class="form-control" >
                                                <option value="">@lang('home.main_categories')</option>
                                                @foreach($categories as $category)
                                                <option 
                                                value="{{@$category->id}}" >
                                                {{@$category->category_translation->name}}
                                            </option>
                                            @endforeach
                                        </select>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                           <div class="alert alert-danger alert-dismissible" id="sub_categoris_unknown">
                                            <a href="#" class="close" data-dismiss="alert" aria-label="close" style="right: 5px;">&times;</a>@lang('home.empty_sub_categories')
                                        </div>
                                        <div >
                                           <select name="sub_categoris" id="sub_categoris" class="form-control" >
                                            <option value="">@lang('home.classifications')</option>

                                        </select>
                                        </div>
                                    </div>
                                        <div class="col-12">
                                        	<select name="purpose_id" class="form-control" >
                                        		<option value="0">@lang('home.ad_purpose') </option>
                                        		@foreach($ad_purpose as $purpose)
                                        		<option value="{{ @$purpose->id }}" 
                                        			@if(Request::old('purpose_id') == $purpose->id) 
                                        			selected 
                                        			@elseif($ad != null)
                                        			@if(@$ad->purpose_id  == $purpose->id)
                                        			selected 
                                        			@endif
                                        			@endif
                                        			>{{ $purpose->translation->name }} </option>
                                        			@endforeach

                                        		</select>
                                        </div>
                                    @if($site_langs->count() > 0)
                                    @foreach($site_langs as $key => $lang)

                                    <!-- categories input -->
                                    <input type="hidden" name="lang[]" value="{{ @$lang->id }}">
                                    <!-- title  input -->
                                     <div class="col-lg-12"  style="margin: 8px 0px 8px 0px">
                                            <input  type="text"
                                            name="title[]" 
                                            class="form-control" 
                                            placeholder="@lang('home.title_'.@$lang->info->local)" 
                                            value="{{Request::old('title')[$key]}}">
                                    </div>
                                    <!-- /title  input -->
                                  
                                    {{-- content  --}}
                                        <div class="col-lg-12"  style="margin: 8px 0px 8px 0px">
                                            <textarea name="content[]"
                                            id="editor1" 
                                            rows="4" 
                                            cols="4"  
                                            class="form-control" 
                                            placeholder="@lang('home.content_'.@$lang->info->local)">{{Request::old('content')[$key]}}</textarea>
                                        </div>

                                {{-- content ar --}}
                                @endforeach
                                @endif
                                     {{--    <div class="col-12">
                                            <input type="text" class="form-control" placeholder="عنوان الاعلان">
                                        </div>
                                        <div class="col-12">
                                            <input type="text" class="form-control" placeholder="الغرض من الاعلان">
                                        </div> --}}
                              	<div class="col-12">
                              		<input type="text" 
                              		name="price" 
                              		class="form-control"  
                              		placeholder="@lang('home.price')" 
                              		value="{{ Request::old('price') }}">
                              	</div>	
                                <div class="col-12">
                                	<input type="text" 
                                	name="share_link" 
                                	class="form-control " 
                                	placeholder="@lang('home.share_link')" 
                                	value="{{ Request::old('share_link') }}" >
                                </div>
                                <div class="col-12">
										<input type="text" name="address" id="address1" class="form-control"  onkeyup="findAddress()"  value="{{@$ad->address}}" placeholder="@lang('home.address')" />
                                	<div class="row">
                                    	<div class="col-md-6">
                                    		<input type="text" name="lat" id="cityLat1" placeholder="Lattitude" class="form-control" required="required" value="{{@$ad->lat}}" disabled />
							                <input type="hidden" name="lat" id="cityLat" placeholder="Lattitude" class="form-control" required="required" value="{{@$ad->lat}}" />
                                		</div>
                                		<div class="col-md-6">
                                			<input type="text" name="long" id="cityLng1" placeholder="Longitude" class="form-control" required="required" value="{{@$ad->long}}" disabled  />
							                <input type="hidden" name="long" id="cityLng" placeholder="Longitude" class="form-control" required="required" value="{{@$ad->long}}" />
                                		</div>
                                	</div>

                                </div>
                                    
                                        <div class="col-12">
                                            <div class="file">
                                                <input class="form-control" type="file" name="images[]" multiple>
                                                <span>رفع صوره</span>
                                            </div>
                                        </div>
                                        <div class="col-md-12">
                                            <div class="custom-control custom-checkbox">
                                                <input type="checkbox" class="custom-control-input"  name="terms" id="customCheck1">
                                                <label class="custom-control-label" for="customCheck1">
                                                    <p>الموافقه على الشروط</p>
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                    <button class="butn"><span>تسجيل</span></button>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </main>
    <!--End-Contents-->
@stop


@section('jsCode')
<script type="text/javascript">


//script getting sub categories fillter
$('#sub_categoris').show();

$('#sub_categoris_unknown').hide()
$('#parent_id').on('change',function () {
    // console.log($(this).val());

    if ($(this).val() != '') {
        var parent_id = $(this).val();
        $.ajax({
            'url' : '{{ URL::to('/') }}/api/categories/' + parent_id,
            'type' : 'GET',
            'success' : function(data) {     
               console.log(data.data.length );
                if (data.data.length == 0) {
                    $('#sub_categoris').fadeOut();
                    $('#sub_categoris_unknown').fadeIn();
                    console.log('empty');
                } //where sub categories list  length = 0
                else{//where sub categories list  length  > 0 will append in #sub_categoris

                    $('#sub_categoris').fadeIn();
                    $('#sub_categoris_unknown').fadeOut();
                    $('#sub_categoris').empty()
                    console.log('fully');

                    for (var i = data.data.length - 1; i >= 0; i--) {
                        $('#sub_categoris').append("<option value='"+data.data[i].id+"'>"+data.data[i].category_translation.name+"</option")   
                    }
                }   
            }//server success case 
            ,'error' : function(request,error)
            {
                $('#sub_categoris').fadeOut();
                $('#sub_categoris_unknown').fadeIn();
            }//server error case 
        });
    }else{
        $('#sub_categoris').fadeOut();
        $('#sub_categoris_unknown').fadeIn();
    }
});

</script>

<script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyAK34ZyoH4758BkVP05-GxKP0dSmBi4yTo&libraries=places"></script>
<script type="text/javascript">
    var x = document.getElementById("address1");
    function getLocation() {
        if (navigator.geolocation) {
            navigator.geolocation.getCurrentPosition(showPosition);
        } else {
            x.innerHTML = "Geolocation is not supported by this browser.";
        }
    }
    function showPosition(position) {
        document.getElementById('cityLat').value = position.coords.latitude;
        document.getElementById('cityLng').value =  position.coords.longitude;
        document.getElementById('cityLat1').value = position.coords.latitude;
        document.getElementById('cityLng1').value =  position.coords.longitude;

        document.getElementById('address1').value ='';
    }
    //start live search locaton and get lat & long
    function findAddress() {
        var input = document.getElementById('address1');
        var autocomplete = new google.maps.places.Autocomplete(input);
        google.maps.event.addListener(autocomplete, 'place_changed', function () {

            var place = autocomplete.getPlace();
        console.log(place);
            document.getElementById('cityLat').value = place.geometry.location.lat();
            document.getElementById('cityLng').value = place.geometry.location.lng();
            document.getElementById('cityLat1').value = place.geometry.location.lat();
            document.getElementById('cityLng1').value = place.geometry.location.lng();
        });
    }
    //end live search
</script>
@stop