@extends('front.layouts.main')
@section('meta_tags')
    <title>@lang('home.create_group') | {{@$setting->translation->title}}</title>
    <meta name='description' itemprop='description' content='{!! @$info->translation->content!!}' />
    <meta name='keywords' content='{!!@$setting->meta_tags!!},{!!@$info->translation->title !!},{!!@$info->mission !!},{!!@$info->goals!!}' />
    <meta property="og:description"content="{{ @$info->translation->content }}" />
    <meta property="og:title"content="@lang('home.create_group') | {{@$setting->translation->title}} " />
    <meta property="og:url"content="{{URL::to('/about_us')}}" />
    <meta property="og:site_name"content="{{@$setting->translation->title}}" />
    <meta property="og:image" content="{{URL::to('/').@$setting->logo}}">

    <meta name="twitter:card"content="summary" />
    <meta name="twitter:title"content="@lang('home.create_group')| {{@$setting->translation->title}}" />
    <meta name="twitter:site"content="@wait" />
@stop
@section('content')
<!--Contents-->
<main class="inner-pages">
<div class="inner-header">
<div class="page-title">
	<div class="container">
		<h5 class=""><a href="{{ url(LaravelLocalization::getCurrentLocale()) }}">@lang('home.home')</a> /@lang('home.create_group')</h5>
	</div>
</div>
</div>
<!-- ======================== start about =========================== -->
<section class="contact section-padding">
<div class="container">
	<div class="section-head text-center">
		<h2>@lang('home.create_group') </h2>
	</div>
	<div class="login">
		<div class="row">
			<div class="col-lg-6 offset-lg-3">
				<div class="contact-form contact-box">
					<form action="{{ URL::to( url(LaravelLocalization::getCurrentLocale()).'/groups/sotre') }}" method="post" enctype="multipart/form-data">
					@csrf
					@if ($errors->any())
					@foreach ($errors->all() as $error)
					<div class="alert alert-danger alert-dismissible" >
						<a href="#" class="close" data-dismiss="alert" aria-label="close" style="right: 5px;">&times;</a>{{@$error }}
					</div>
					@endforeach
					@endif
					@if(Session::has('success'))
					<div class="alert alert-success alert-dismissible">
						<a href="#" class="close" data-dismiss="alert" aria-label="close" style="right: 5px;">&times;</a>{{ Session::get('success') }}
					</div>
					@endif
						<div class="form-row">
							@if($site_langs->count() > 0)
                            @foreach($site_langs as $key => $lang)
                            <input type="hidden" name="lang[]" value="{{ @$lang->id }}">

							<div class="col-12">
								<input type="text" name="name[]" class="form-control" placeholder="@lang('home.group_name') @lang('home.'.$lang->info->local)">
							</div>
							@endforeach
                        	@endif

							<select class="custom-select form-control" name="privacy" id="inputGroupSelect01">
								<option selected>@lang('home.privacy')</option>
								<option value="private">@lang('home.private')</option>
								<option value="public">@lang('home.public')</option>
							</select>
							<select class="custom-select form-control" id="inputGroupSelect01" name="members[]" multiple>
								<option selected>@lang('home.add_member_group')</option>
								@foreach($users as $user)
								<option value="{{ @$user->id }}">{{ @$user->fname.' '.$user->lname.' '.$user->family_name.'-'.$user->email }}</option>
								@endforeach
							</select>

							<div class="col-12">
								<div class="file">
									<input class="form-control" type="file" name="icon">
									<span>@lang('home.icon')</span>
								</div>
							</div>
						</div>
						<button class="butn"><span>أنشاء</span></button>
					</form>
				</div>
			</div>
		</div>
	</div>
</div>
</section>
@stop