@extends('front.layouts.main')
@section('meta_tags')
    <title>@lang('home.profile') | {{@$setting->translation->title}}</title>
    <meta name='description' itemprop='description' content='{!! @$info->translation->content!!}' />
    <meta name='keywords' content='{!!@$setting->meta_tags!!},{!!@$info->translation->title !!},{!!@$info->mission !!},{!!@$info->goals!!}' />
    <meta property="og:description"content="{{ @$info->translation->content }}" />
    <meta property="og:title"content="@lang('home.profile') | {{@$setting->translation->title}} " />
    <meta property="og:url"content="{{URL::to('/about_us')}}" />
    <meta property="og:site_name"content="{{@$setting->translation->title}}" />
    <meta property="og:image" content="{{URL::to('/').@$setting->logo}}">

    <meta name="twitter:card"content="summary" />
    <meta name="twitter:title"content="@lang('home.profile')| {{@$setting->translation->title}}" />
    <meta name="twitter:site"content="@wait" />
@stop
@section('content')
<!--Contents-->
<main class="inner-pages profile-pg">
<div class="inner-header">
    <div class="page-title">
        <div class="container">
            <h5 class=""><a href="#">@lang('home.home')</a> / @lang('home.profile')</h5>
        </div>
    </div>
</div>
<section class="profile">
    <div class="pg-content section-padding">
        <div class="container">
            <div class="row">
                <div class="col-md-3">
                    <div class="fixed-r-nav">
                        <div class="img">
                            <img id="img-profile" class="img-fluid image-profile" src="{{ @asset($user->image) }}"
                                alt="your image">
                            @if(Auth::check() && Auth::id() != $user->id)
                            @if(in_array(Auth::id(),$followers->toArray()) ==false)
                            <a href="{{ url(LaravelLocalization::getCurrentLocale()).'/user/'.'follow/u/'.@$user->id }}" class="btn btn-primary">follow</a>
                            @else
                             <a href="{{ url(LaravelLocalization::getCurrentLocale()).'/user/'.'follow/u/'.@$user->id }}" class="btn btn-primary">unfollow</a>
                            @endif
                            @endif
                        </div>
                        <div class="text-center mt-3">
                            
                        </div>
                        <ul class="nav nav-tabs">
                            <li class="active"><a data-toggle="tab" href="#home">@lang('home.profile_info')</a></li>
                            @if($user->id == Auth::id())
                            <li><a data-toggle="tab" href="#menu1">@lang('home.update')</a></li>
                            @endif

                            <li><a data-toggle="tab" href="#menu4">@lang('home.ads') </a></li>
                            <li><a  href="{{ url(LaravelLocalization::getCurrentLocale()).'/groups/i' }}">@lang('home.my_groups') </a></li>
                            <li><a href="{{ url(LaravelLocalization::getCurrentLocale()).'/user/followers/'.@$user->id }}">@lang('home.followers')</a></li>
                            <li><a href="{{ url(LaravelLocalization::getCurrentLocale()).'/user/following/'.@$user->id }}">@lang('home.following')</a></li>
                        </ul>
                    </div>
                </div>
                <div class="col-md-9">
                    <div class="tabs">
                        <div class="tab-content">
                            <div id="home" class="tab-pane fadeIn active tab1">
                                <div class="content">
                                    <div class="row">
                                        <div class="items col-md-6">
                                            <h5>@lang('home.name') : <span> {{ @$user->fname.' '.@$user->lname .' '.$user->family_name}}</span></h5>
                                        </div>
                                        <div class="items col-md-6">
                                            <h5>@lang('home.email') : <span>{{ @$user->email }}</span></h5>
                                        </div>
                                     
                                        <div class="items col-md-6">
                                            <h5>
                                                @lang('home.gander') : 
                                                @if(@$user->gander == 'male')
                                                @lang('home.male')
                                                @elseif(@$user->gander == 'female')
                                                @lang('home.female')
                                                @endif
                                                <span></span>
                                            </h5>
                                        </div>
                                        <div class="items col-md-6">
                                            <h5>@lang('home.phone') : 
                                                @if($user->phone !=null)
                                                    <span>{{ @$user->phone }}</span>
                                                @else
                                                    <span>@lang('home.note_entered')</span>
                                                @endif
                                            </h5>
                                        </div>
                                        <div class="items col-md-6">
                                            <h5>@lang('home.nationality') : 
                                                @if($user->country !=null)
                                                <span>{{$user->country->translations->where('lang_id',$active_lang->id)->first()->name }}</span>
                                                @else
                                                 <span>@lang('home.note_entered')</span>
                                                @endif
                                            </h5>
                                        </div>
                                        <div class="items col-md-6">
                                            <h5>@lang('home.job_title'): <span>{{ @$user->job_title }}</span></h5>
                                        </div>
                                        <div class="items col-md-6">
                                            <h5>@lang('home.address') : 
                                                {{ @$user->address }}
                                                @if($user->country !=null)
                                                <span>{{$user->country->translations->where('lang_id',$active_lang->id)->first()->name }}</span>
                                                @endif
                                                -
                                                @if($user->city !=null)
                                                <span>{{@$user->city->translations->where('lang_id',$active_lang->id)->first()->name }}</span>
                                                @else
                                                 <span>@lang('home.note_entered')</span>
                                                @endif
                                            </h5>
                                        </div>
                                       
                                        <div class="items col-md-12">
                                            <h5>@lang('home.profile'): <span><a href="{{  url(LaravelLocalization::getCurrentLocale()).'/in/'.@$user->id.'/'.@str_replace(' ', '-', @str_replace(' ', '-', $user->fname).'-'.@str_replace(' ', '-', $user->lname).'-'.@str_replace(' ', '-', $user->family_name)) }}">{{  url(LaravelLocalization::getCurrentLocale()).'/in/'.@$user->id.'/'.@str_replace(' ', '-', @str_replace(' ', '-', $user->fname).'-'.@str_replace(' ', '-', $user->lname).'-'.@str_replace(' ', '-', $user->family_name)) }}</a></span></h5>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div id="menu1" class="tab-pane fade">
                                <form method="post" action="{{ url('profile/u/update') }}"  enctype='multipart/form-data'>
                                    
                                    @if ($errors->any())
                                    @foreach ($errors->all() as $error)
                                    <div class="alert alert-danger alert-dismissible" >
                                        <a href="#" class="close" data-dismiss="alert" aria-label="close" style="right: 5px;">&times;</a>{{@$error }}
                                    </div>
                                    @endforeach
                                    @endif
                                    @if(Session::has('success'))
                                    <div class="alert alert-success alert-dismissible">
                                        <a href="#" class="close" data-dismiss="alert" aria-label="close" style="right: 5px;">&times;</a>{{ Session::get('success') }}
                                    </div>
                                    @endif
                                    @csrf
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form">
                                                <div class="form-group">
                                                    <label for="">@lang('name')</label>
                                                    <input class="form-control" name="name" type="text" value="{{ @Auth::user()->fname }}" required>
                                                </div>

                                                <div class="form-group">
                                                    <label for="">@lang('home.email')</label>
                                                    <input class="form-control" name="email" value="{{ @Auth::user()->email }}" type="text">
                                                </div>

                                                <div class="form-group">
                                                    <label for="">@lang('home.phone')</label>
                                                    <input class="form-control" name="phone" type="text" value="{{ @Auth::user()->phone }}">
                                                </div>

                                                <div class="form-group">
                                                    <label for="">@lang('home.governmental_id')</label>
                                                    <input class="form-control" name="governmental_id" type="text" value="{{ @Auth::user()->governmental_id }}">
                                                </div>

                                                <div class="form-group">
                                                    <label for="">@lang('home.commercial_register')</label>
                                                    <input class="form-control" name="commercial_register" type="text"  value="{{ @Auth::user()->commercial_register }}">
                                                </div>

                                                 <div class="form-group">
                                                    <label for="">@lang('home.password')</label>
                                                    <input class="form-control" name="password" type="text">
                                                </div>



                                               
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form">
                                                <div class="form-group">
                                                    <label for="">@lang('home.address')</label>
                                                    <input class="form-control" name="address" type="text" required  value="{{ @Auth::user()->address }}">
                                                </div>
                                                <div class="form-group">
                                                    <label for="">@lang('home.job_title')</label>
                                                    <input class="form-control" name="job_title" type="text" required  value="{{ @Auth::user()->job_title }}">
                                                </div>
                                                 <select name="country_id" class="form-control">
                                                    <option value="0">@lang('home.nationality')</option>
                                                    @foreach($countries as $country)
                                                        <option value="{{ @$country->id }}" @if($country->id == Auth::user()->country_id) selected @endif>{{ @$country->translations->where('lang_id',$active_lang->id)->first()->name }}</option>
                                                    @endforeach

                                                    </select>
                                                    <select name="city_id" class="form-control">
                                                    <option value="0">@lang('home.cities')</option>
                                                    @foreach($cities as $city)
                                                        <option value="{{ @$city->id }}" @if($city->id == Auth::user()->city_id) selected @endif>{{ @$city->translations->where('lang_id',$active_lang->id)->first()->name }}</option>
                                                    @endforeach
                                                    </select>

                                                    <div class="form-group">
                                                      
                                                        <select name="gander" class="form-control">
                                                            <option value="">@lang('home.gander')</option>
                                                            <option value="male" @if(Auth::user()->gander =='male') selected @endif>@lang('home.male')</option>
                                                            <option value="female" @if(Auth::user()->gander =='female') selected @endif>@lang('home.female')</option>
                                                        </select>
                                                    </div>
                                                    <div class="col-md-12">
                                                        <div class="file">
                                                            <input class="form-control" type="file" name="image">
                                                            <span>صورة الملف الشخصي</span>
                                                        </div>
                                                    </div>
                                                    <div class="form-group">
                                                        <label for="">@lang('home.password_confirmation')</label>
                                                        <input class="form-control" name="password_confirmation" type="text">
                                                    </div>
                                        </div>
                                    </div>
                                    <button class="butn" href="#"><span>حفظ البيانات</span></button>
                                </div>
                            </form>
                            </div>
                            <div id="menu4" class="tab-pane fade new">
                                <div class="lead-section">
                                    <div class="lead-table">
                                        <table class="table table-bordered">
                                            <thead>
                                                <tr>
                                                    <th scope="col">#</th>
                                                    <th scope="col">@lang('home.title')</th>
                                                    <th scope="col">@lang('home.ad_purpose')</th>
                                                    <th scope="col">@lang('home.date_time')</th>
                                                    <th scope="col">@lang('home.statistics')</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                            @if($user->ads->count() > 0)
                                             @foreach($user->ads as $ad)
                                             <tr>
                                                <td>{{ @$ad->id }}</td>
                                                <td><a href="{{url(LaravelLocalization::getCurrentLocale().'/ad/'.@$ad->id.'/'. str_replace(' ','_',$ad->translations->where('lang_id',$active_lang->id)->first()->title) )}}">{{ $ad->translations->where('lang_id',$active_lang->id)->first()->title }}</a></td>
                                                <td>{{ @$ad->ad_purpose->translations->where('lang_id',$active_lang->id)->first()->name }}</td>
                                                <td> {{@Carbon\Carbon::parse($ad->created_at)->diffForHumans()}} -  {{ @$ad->created_at }}</td>
                                                <td>{{ @$ad->visit }} @lang('home.visits') <br>3 ردود</td>
                                            </tr>
                                            @endforeach
                                            @else
                                            <tr >
                                                <td colspan="5">@lang('home.no_ads_here')</td>
                                             </tr>
                                             @endif
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
</main>
<!--End-Contents-->
@stop